#!/bin/bash

# Configuration section
USER="SAP_ALL DOMAIN USER ACCOUNT" # CHANGE ME! ;-)
PASS="SAP_ALL DOMAIN PASSWORD"     # CHANGE ME! ;-)
DEST="SOME FOLDER INSIDE WEBROOT"  # CHANGE ME! ;-)

# Get the most recent input files from localsdp
cd ./in/
smbget -u $USER -p $PASS smb://localsdp/root/_Packages/Global/SAP-IT/sappcadm/files/sapmsg.ini
smbget -u $USER -p $PASS smb://localsdp/root/_Packages/Global/SAP-IT/sappcadm/files/saproute.ini
smbget -u $USER -p $PASS smb://localsdp/root/_Packages/Global/SAP-IT/sappcadm/files/services.unx


# Make sure all required input files exist
if [ -e ./in/sapmsg.ini ]; then 
	echo "ERROR: Input file sapmsg.ini is missing!"
	exit 1
fi
if [ -e ./in/saproute.ini ]; then
	echo "ERROR: Input file saproute.ini is missing!"
	exit 1
fi
if [ -e ./in/services.unx ]; then
	echo "ERROR: Input file services.unx is missing!"
	exit 1
fi

# Convert the files
cd ..
perl generateMessageServers.pl -m ./in/sapmsg.ini -s ./in/services.unx -j ./out/messageservers.txt -d ./out/systemdesc.txt -o
perl generateRouters.pl -w ./in/saproute.ini -j ./out/routers.txt -o

# Put the generated files on the webserver
#move "D:\inetpub\wwwjavagui\config\*.txt" "D:\inetpub\wwwjavagui\config\saveold\"
cp out/*.* $DEST

# Clean up
rm ./in/sapmsg.ini
rm ./in/saproute.ini
rm ./in/services.unx

